//
// game.cpp - Fruit Ninja
// 

// Engine includes.
#include "GameManager.h"
#include "LogManager.h"

// Game includes.
#include "Fruit.h"
#include "game.h"
#include "util.h"

///////////////////////////////////////////////
int main(int argc, char *argv[]) {

  // Start up game manager.
  if (GM.startUp())  {
    LM.writeLog("Error starting game manager!");
    GM.shutDown();
    return 0;
  }

  // Setup logging.
  LM.setFlush(true);
  LM.setLogLevel(1);
  LM.writeLog("Fruit Ninja (v%.1f)", VERSION);
  
  // Load resources.
  loadResources();

  // Dragonfly splash screen.
  df::splash();

  // Spawn a Fruit.
  Fruit *p_f = new Fruit(FRUIT[rand() % NUM_FRUITS]);
  p_f -> start(0.25f);
  
  GM.run();

  // Shut everything down.
  GM.shutDown();

  // All is well.
  return 0;
}
