//
// game.cpp - Fruit Ninja
// 

// Engine includes.
#include "GameManager.h"
#include "LogManager.h"

// Game includes.
#include "game.h"

///////////////////////////////////////////////
int main(int argc, char *argv[]) {

  // Start up game manager.
  if (GM.startUp())  {
    LM.writeLog("Error starting game manager!");
    GM.shutDown();
    return 0;
  }

  // Setup logging.
  LM.setFlush(true);
  LM.setLogLevel(1);
  LM.writeLog("Fruit Ninja (v%.1f)", VERSION);
  
  // Dragonfly splash screen.
  df::splash();

  // Shut everything down.
  GM.shutDown();

  // All is well.
  return 0;
}
