//
// GameOver.cpp
//

// Engine includes.
#include "EventStep.h"
#include "LogManager.h"
#include "ResourceManager.h"
#include "WorldManager.h"

// Game includes.
#include "GameOver.h"
#include "GameStart.h"

GameOver::GameOver() {

  setType("GameOver");

  // Link to "message" sprite.
  if (setSprite("gameover") == 0)
    time_to_live = getAnimation().getSprite()->getFrameCount() * getAnimation().getSprite()->getSlowdown();
  else
    time_to_live = 0;

  // Put in center of window.
  setLocation(df::CENTER_CENTER);
  
  // Register for step event.
  registerInterest(df::STEP_EVENT);

}

// When done, game over so reset things for GameStart.
GameOver::~GameOver() {

  // Remove Saucers and ViewObjects, re-activate GameStart.
  df::ObjectList object_list = WM.getAllObjects(true);
  for (int i=0; i<object_list.getCount(); i++) {
    df::Object *p_o = object_list[i];
    if (p_o -> getType() == "Saucer" || p_o -> getType() == "ViewObject")
      WM.markForDelete(p_o);
    if (p_o -> getType() == "GameStart") {
      p_o -> setActive(true);
    }
  }
}

// Handle event.
// Return 0 if ignored, else 1.
int GameOver::eventHandler(const df::Event *p_e) {

  if (p_e->getType() == df::STEP_EVENT) {
    step();
    return 1;
  }

  // If get here, have ignored this event.
  return 0;
}

// Count down to end of message.
void GameOver::step() {
  time_to_live--;
  if (time_to_live <= 0)
    WM.markForDelete(this);
}

// Override default draw so as not to display "value".
int GameOver::draw() {
  return df::Object::draw();
}
