//
// Hero.cpp
//

// Engine includes.
#include "EventStep.h"
#include "EventView.h"
#include "GameManager.h"
#include "LogManager.h"
#include "ResourceManager.h"
#include "WorldManager.h"

// Game includes.
#include "Hero.h"

Hero::Hero() {

  // Link to "ship" sprite.
  setSprite("ship");

  // Player controls hero, so register for input events.
  registerInterest(df::KEYBOARD_EVENT);

  // Need to update rate control each step.
  registerInterest(df::STEP_EVENT);

  // Set object type.
  setType("Hero");

  // Set starting location.
  df::Vector p(7, WM.getBoundary().getVertical()/2);
  setPosition(p);

  // Set attributes that control actions.
  move_slowdown = 2;
  move_countdown = move_slowdown;
  dy = 0;
}
  
// Handle event.
// Return 0 if ignored, else 1.
int Hero::eventHandler(const df::Event *p_e) {

  if (p_e->getType() == df::KEYBOARD_EVENT) {
    const df::EventKeyboard *p_keyboard_event = dynamic_cast <const df::EventKeyboard *> (p_e);
    kbd(p_keyboard_event);
    return 1;
  }

  if (p_e->getType() == df::STEP_EVENT) {
    step();
    return 1;
  }
 
  // If get here, have ignored this event.
  return 0;
}
// Take appropriate action according to key pressed.
void Hero::kbd(const df::EventKeyboard *p_keyboard_event) {

  switch(p_keyboard_event->getKey()) {
  case df::Keyboard::W:       // up
    if (p_keyboard_event->getKeyboardAction() == df::KEY_PRESSED)
      dy -= 1;
    if (p_keyboard_event->getKeyboardAction() == df::KEY_RELEASED)
      dy += 1;
    break;
  case df::Keyboard::S:       // down
    if (p_keyboard_event->getKeyboardAction() == df::KEY_PRESSED)
     dy += 1;
    if (p_keyboard_event->getKeyboardAction() == df::KEY_RELEASED)
     dy -= 1;
    break;
  case df::Keyboard::Q:       // quit
    if (p_keyboard_event->getKeyboardAction() == df::KEY_PRESSED) 
      GM.setGameOver();
    break;
  default: // Key event doesn't do anything.
    return;
  };

  return;
}

// Move up or down.
void Hero::move(int dy) {

  // See if time to move.
  if (move_countdown > 0)
    return;
  move_countdown = move_slowdown;

  // If stays on window, allow move.
  df::Vector new_pos(getPosition().getX(), getPosition().getY() + dy);
  if ((new_pos.getY() > 3) && 
      (new_pos.getY() < WM.getBoundary().getVertical()-1))
    WM.moveObject(this, new_pos);
}
// Decrease rate restriction counters.
void Hero::step() {

  // Move countdown.
  move_countdown--;
  if (move_countdown < 0)
    move_countdown = 0;

  // If delta-y is non-zero, move.
  if (dy)
    move(dy);
}
