#!/bin/sh
#% the next line restarts using wish \
exec wish "$0" "$@"
#%
# All of the source code, object code, data files, image files,
# documentation, and any other associated RenderWrapper files are considered
# copyrighted property of Lindeman Systems International, Ltd. Any
# distribution, by electronic or other means, by any person other than
# those authorized to do so by Lindeman Systems International, Ltd. is
# prohibited by law.
#
# Besides, it's just not ethical to distribute someone else's software
# without giving the author proper compensation. So please don't do it!
#
# Copyright (c) 1999 Lindeman Systems International, Ltd.
#               All Rights Reserved.
#
# -------------------------------------------------------------------------
# Function    : RenderWrapper
#
# Description : This is the main menu for the RenderWrapper program.
#
# Parameters  : void.
#
# Returns     : void.
#
# -------------------------------------------------------------------------
# Function    : InitProg { argc argv }
#
# Description : This procedure initializes all the global variables for the
#               program.
#
# Parameters  : argc : Number of command-line arguments.
#               argv : Vector of command-line arguments.
#
# Returns     : void.

proc InitProg { argc argv }  {
  global ProgName
  global BarFG
  global BarBG
  global BarFrameFG
  global BarFrameBG
  global BarFont
  global MessageFG
  global MessageBG
  global MessageFont
  global DefaultFG
  global DefaultBG
  global DefaultAFG
  global DefaultABG
  global DefaultTrough
  global DefaultMenuFG
  global DefaultMenuBG
  global DefaultMenuAFG
  global DefaultMenuABG
  global DefaultMenuSBG
  global DefaultEntryFG
  global DefaultEntryBG
  global CRTFont
  global CRAFont
  global CRCFont
  global TitleFG
  global TitleBG
  global DefaultFont
  global PromptFont
  global EntryFont
  global HelpFont
  global HelpHeaderFont
  global BarString
  global BarLength
  global SmallScreen
  global XRes
  global YRes
  global Version
  global Release
  global IconName
  global tcl_platform
  global tcl_version
  global CopyrightLine
  global IconImage
  global WishExe

  # State-Variables
  global Renderer
  global RIBSource
  global CmdLine

  global Rendrib
  global RGL

  set Rendrib(ResX)          ""
  set Rendrib(ResY)          ""
  set Rendrib(SamplesX)      ""
  set Rendrib(SamplesY)      ""
  set Rendrib(VarV)          ""
  set Rendrib(VarMin)        ""
  set Rendrib(VarMax)        ""
  set Rendrib(StartFrame)    ""
  set Rendrib(EndFrame)      ""
  set Rendrib(RadioSteps)    ""
  set Rendrib(RadioSamples)  ""
  set Rendrib(CropX1)        ""
  set Rendrib(CropY1)        ""
  set Rendrib(CropX2)        ""
  set Rendrib(CropY2)        ""
  set Rendrib(Safe)           0
  set Rendrib(Display)        0
  set Rendrib(DispInterlace) ""
  set Rendrib(PosX)          ""
  set Rendrib(PosY)          ""
  set Rendrib(Ascii)          0
  set Rendrib(Verbose)        0
  set Rendrib(Stats)          0
  set Rendrib(Silent)         0
  set Rendrib(Rayserver)      0

  set RGL(ResX)              ""
  set RGL(ResY)              ""
  set RGL(PosX)              ""
  set RGL(PosY)              ""
  set RGL(CropX1)            ""
  set RGL(CropY1)            ""
  set RGL(CropX2)            ""
  set RGL(CropY2)            ""
  set RGL(StartFrame)        ""
  set RGL(EndFrame)          ""
  set RGL(SyncN)             ""
  set RGL(NoWait)             0
  set RGL(Stats)              0
  set RGL(1Buffer)            0
  set RGL(Sketch)             0
  set RGL(DumpRGB)            0
  set RGL(Display)            1
  set RGL(Verbose)            0
  set RGL(Wireframe)          0
  set RGL(IgnoreLights)       0
  set RGL(Detail)            ""
  set RGL(FrameCommand)      ""
  set RGL(SoundFile)         ""

  set ProgName           "RenderWrapper"
  set BarFG              yellow
  set BarBG              blue
  set BarFrameFG         black
  set BarFrameBG         lightgrey
  set BarFont            { Courier 14 }
  set MessageFG          white
  set MessageBG          black
  set MessageFont        { Courier 12 }
  set DefaultFG          black
  set DefaultBG          lightgrey
  set DefaultAFG         black
  set DefaultABG         snow2
  set DefaultTrough      grey
  set DefaultMenuFG      $DefaultFG
  set DefaultMenuBG      $DefaultBG
  set DefaultMenuAFG     $DefaultFG
  set DefaultMenuABG     $DefaultBG
  set DefaultMenuSBG     $DefaultBG
  set DefaultEntryFG     $DefaultFG
  set DefaultEntryBG     $DefaultBG
  set TitleFG            yellow
  set TitleBG            maroon
  set DefaultFont        { Helvetica 12 bold }
  set PromptFont         { Courier 12 }
  set EntryFont          { Helvetica 12 }
  set HelpFont           { Helvetica 12 }
  set HelpHeaderFont     { Helvetica 16 bold }
  set BarString          "                    %3d%%                     "
  set BarLength          45
  set SmallScreen        "FALSE"
  # Get the dimensions of the screen.
  set XRes [ winfo screenwidth . ]
  set YRes [ winfo screenheight . ]
  set Version            "1.1"
  set Release            ".0"
  set IconName           "$ProgName ${Version}${Release}"
  set CopyrightLine "Copyright (c) 1999 Lindeman Systems International, Ltd. - All Rights Reserved"
  set CmdLine            ""

  # Initialize the global params.
  set CurRenderer        ""
  set CurRIBSource       ""
  set CurRIBFile         ""
  set CurRIBProg         ""
  set decimalPoint       [ string first . $tcl_version ]
  set WishExe            [ format "wish%d%d" \
                                  [ string range $tcl_version 0 [ expr $decimalPoint - 1 ] ] \
                                  [ string range $tcl_version [ expr $decimalPoint + 1 ] end ] ]

  # Set the platform-dependent stuff.
  switch -regexp -- $tcl_platform(platform)  { \
    ^macintosh$  {
       ;# Nothing to do here.
    } \
    ^windows$  {
      # Close the extra console that Win Tcl creates.
      console hide

      set DefaultFG          SystemButtonText
      set DefaultBG          SystemButtonFace
      set DefaultAFG         SystemButtonText
      set DefaultABG         SystemButtonFace
      set DefaultTrough      "#C3C3C3"
      set DefaultMenuFG      SystemMenuText
      set DefaultMenuBG      SystemMenu
      set DefaultMenuAFG     SystemHighlightText
      set DefaultMenuABG     SystemHighlight
      set DefaultMenuSBG     SystemMenuText
      set DefaultFont        { Helvetica 12 bold }
      # Fonts for the "about" window.
      set CRTFont            { Helvetica 12 bold }
      set CRAFont            { Helvetica 8 }
      set CRCFont            { Helvetica 8 }

      # Set the icon label for the program.
      wm iconname   . $IconName
    } \
    ^unix$  {
      set DefaultFG          black
      set DefaultBG          "#D9D9D9"
      set DefaultAFG         black
      set DefaultABG         "#ECECEC"
      set DefaultTrough      "#C3C3C3"
      set DefaultMenuFG      black
      set DefaultMenuBG      "#D9D9D9"
      set DefaultMenuAFG     black
      set DefaultMenuABG     "#ECECEC"
      set DefaultMenuSBG     "#B03060"
      set DefaultFont        { Helvetica 12 bold }
      # Fonts for the "about" window.
      set CRTFont            { Helvetica 18 bold }
      set CRAFont            { Helvetica 12 }
      set CRCFont            { Helvetica 10 }

      # Set the icon label for the program.
      wm iconname . $IconName
    } \
  }

# Set the icon.
#wm iconbitmap . @$IconImage

  # Check for the year.
#  if { $argc > 0 }  {
#    foreach arg $argv  {
#      switch -regexp -- $arg  { \
#        default  {
#          Usage
#        } \
#      }
#    }
#  }
};

# -------------------------------------------------------------------------
# Function    : CleanUpAndExit { askUser }
#
# Description : This procedure exits the program. The user is asked to
#               acknowledge if askUser is 1.
#
# Parameters  : askUser : FLAG: Ask user before exiting?
#
# Returns     : void.

proc CleanUpAndExit { askUser }  {
  if { $askUser == 1 }  {
    ;
    exit
  } else  {
    exit
  }
}

# -------------------------------------------------------------------------
# Function    : GiveHelp { parentTag }
#
# Description : This procedure outputs a help screen.
#
# Parameters  : parentTag : Tag for the parent widget.
#
# Returns     : void.

proc GiveHelp { parentTag }  {
  global tcl_platform
  global ProgName
  global Version
  global Release
  global DefaultFont

  set fullName [ format "%s %s%s" $ProgName $Version $Release ]
  set helpTag ".help"
  if ![ winfo exists $helpTag ] {
    toplevel $helpTag

    frame $helpTag.buttons
    pack $helpTag.buttons -side bottom -fill x
    button $helpTag.buttons.dismiss -text Dismiss -bd 4 \
       -default active -command "destroy $helpTag" -font $DefaultFont
    pack $helpTag.buttons.dismiss -side left \
       -expand 1 -pady 2
    bind $helpTag.buttons.dismiss <Return> "destroy $helpTag"
    frame $helpTag.frame
    pack  $helpTag.frame -expand yes -fill both -padx 1 -pady 1
    text $helpTag.text -height 20 -width 65 -wrap word \
       -xscrollcommand "$helpTag.xscroll set" \
       -yscrollcommand "$helpTag.yscroll set" -font $DefaultFont \
       -setgrid 1 -highlightthickness 0 -pady 2 -padx 3
    scrollbar $helpTag.xscroll -command "$helpTag.text xview" \
       -highlightthickness 0 -orient horizontal
    scrollbar $helpTag.yscroll -command "$helpTag.text yview" \
       -highlightthickness 0 -orient vertical
    grid $helpTag.text -in $helpTag.frame -padx 1 -pady 1 \
       -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $helpTag.yscroll -in $helpTag.frame -padx 1 -pady 1 \
       -row 0 -column 1 -rowspan 1 -columnspan 1 -sticky news
#    grid $helpTag.xscroll -in $helpTag.frame -padx 1 -pady 1 \
#       -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid rowconfig    $helpTag.frame 0 -weight 1 -minsize 0
    grid columnconfig $helpTag.frame 0 -weight 1 -minsize 0
  } else {
    wm deiconify $helpTag
    raise $helpTag
  }
  wm title $helpTag "Help for RenderWrapper"
  wm iconname $helpTag $fullName
  wm geometry $helpTag "+140+60"

  focus -force $helpTag.buttons.dismiss

  $helpTag.text insert end "
Using RenderWrapper

1. Choosing a Renderer

Select the renderer you wish to use by clicking on the associated
pick list. \"rendrib\" produces the highest quality images, but takes
the most time to render. \"rgl\" is a polygon renderer, but is much
faster than \"rendrib,\" and can be used to preview motion.

Each time a different renderer is selected, the display is updated
based on the parameters available for that particular renderer.

2. The Working Directory

The Working Directory determines which directory will be the default
when the renderer is called. Any RIB file or program command-line
declarations (see below) can be made relative to this directory.

3. Choosing a RIB Source

You must select a \"RIB Source\" before rendering. If \"Read from a RIB
File\" is selected, then the renderer will take its input RIB stream
from a file. If \"Output from a Program\" is selected, then the output
from the specified program will be passed to the renderer as stdandard
input.

You can enter the name of a RIB file or the name of a program, along
with any command-line arguments, in the \"File(s) or Program\" field.

You may use wildcards in this field in order to render multiple frames.
For instance, if you had 100 RIB files named \"rib\frame000.rib\" to
\"rib\frame099.rib\", you could enter \"rib\frame0??.rib\" in this field.
Alternately, you may use the \"Browse...\" button.

You may also specify multiple RIB files to be passed to the render.
For instance, you might have the camera information in one file, and
scene information in another. You could therefore specify
\"optfile scenefile.rib\" in the \"File(s) or Program\" field.

4. Setting Renderer Parameters

Enter the values for any parameters you want to pass to the renderer.
If you want to use the default setting for a given parameter, simply
leave the entry blank (or delete any values you have entered). For a
description of the parameters, see the documentation included with
your BMRT distribution.

5. Rendering

Once you have selected the parameters, click the \"Render\" button
at the bottom of the RenderWrapper screen. This starts the renderer and
displays a status window for the rendering process. Any error messages
will be displayed in the status window. If \"rendrib\" is used as the
renderer, a progress bar will also be displayed.

6. Problems

If you have any problems or comments, please send me mail at
<gogo@lindeman.com> (http://www.seas.gwu.edu/student/gogo/).

Please remember that this software is a fairly simple
(read: Quick-and-Dirty) wrapper for BMRT. It basically represents the
result of a few days of work writing Tcl/Tk scripts.

As such, it might not be the most robust or user-friendly interface,
but I hope you find it useful!
Any suggestions you might have are welcome!

"

  $helpTag.text mark set insert 1.0
  $helpTag.text config -state disabled
}

# -------------------------------------------------------------------------
# Function    : HandleRQ { messTag }
#
# Description : This procedure reacts to the pressing of a button in the
#               GiveCopyright procedure. "butt" is the button pressed.
#
# Parameters  : messTag : Tag of the message-box widget.
#
# Returns     : void.

proc HandleRQ { messTag }  {
  destroy ${messTag}
};

# -------------------------------------------------------------------------
# Function    : GiveAbout { parentTag }
#
# Description : This procedure prompts the displays a copyright message to
#               the user.
#
# Parameters  : parentTag : Tag for the parent widget.
#
# Returns     : void.

proc GiveAbout { parentTag }  {
  global ProgName
  global ButtonRelief
  global CopyrightLine
  global Version
  global Release
  global IconImage
  global CRTFont
  global CRAFont
  global CRCFont
  global DefaultFont
  global DefaultFG
  global DefaultBG
  global DefaultAFG
  global DefaultABG

  set mLine "RenderWrapper"
  set vLine "Version ${Version}${Release}"
  set address1 "This program is shareware."
  set address2 "If you like it, please"
  set address3 "send a \$10 donation to"
  set address4 "the address at our Web site."
  set web1     "Email: gogo@lindeman.com"
  set web2     "Web: http://www.seas.gwu.edu/student/gogo/"
  set crLine $CopyrightLine

  set messTag $parentTag.rq
  toplevel ${messTag}

  # Position the window.
  wm geometry $messTag "+140+60"

  # Put a new title in the window frame.
  wm title $messTag "$ProgName: About..."
  # Set the icon.
#   wm iconbitmap $messTag @$IconImage

  # Require confirmation.
  grab set ${messTag}

  frame ${messTag}.frame -bg $DefaultBG
  frame ${messTag}.addwebFrame -relief flat -bg $DefaultBG
  frame ${messTag}.addFrame -relief flat -bg $DefaultBG
  label ${messTag}.addLabel1 -text $address1 -relief flat -font $CRAFont \
                             -fg $DefaultFG -bg $DefaultBG
  label ${messTag}.addLabel2 -text $address2 -relief flat -font $CRAFont \
                             -fg $DefaultFG -bg $DefaultBG
  label ${messTag}.addLabel3 -text $address3 -relief flat -font $CRAFont \
                             -fg $DefaultFG -bg $DefaultBG
  label ${messTag}.addLabel4 -text $address4 -relief flat -font $CRAFont \
                             -fg $DefaultFG -bg $DefaultBG
  pack ${messTag}.addLabel1 ${messTag}.addLabel2 \
       ${messTag}.addLabel3 ${messTag}.addLabel4 -side top \
       -in ${messTag}.addFrame

  frame ${messTag}.webFrame -relief flat -bg $DefaultBG
  label ${messTag}.webLabel1 -text $web1 -relief flat -font $CRAFont \
                             -fg $DefaultFG -bg $DefaultBG
  label ${messTag}.webLabel2 -text $web2 -relief flat -font $CRAFont \
                             -fg $DefaultFG -bg $DefaultBG
  pack ${messTag}.webLabel1 ${messTag}.webLabel2 -side top \
       -in ${messTag}.webFrame

  pack ${messTag}.addFrame ${messTag}.webFrame -side left \
       -padx 10m -in ${messTag}.addwebFrame

  frame ${messTag}.aboutFrame -relief raised -bg $DefaultBG
  label ${messTag}.mLine -text $mLine -pady 1m -relief flat \
                         -font $CRTFont \
                         -fg $DefaultFG -bg $DefaultBG
  label ${messTag}.vLine -text $vLine -pady 1m -relief flat \
                         -font $CRTFont \
                         -fg $DefaultFG -bg $DefaultBG
  label ${messTag}.crLine -text $crLine -pady 5m -relief flat \
                          -font $CRCFont \
                          -fg $DefaultFG -bg $DefaultBG

  pack ${messTag}.aboutFrame ${messTag}.mLine \
       ${messTag}.vLine -side top -in ${messTag}.frame
  pack ${messTag}.addwebFrame -pady 1m -side top \
       -in ${messTag}.frame
  pack ${messTag}.crLine -side top -in ${messTag}.frame

  pack ${messTag}.frame

  button ${messTag}.ok -text "Ok" -font $DefaultFont \
                      -relief raised -default active \
                      -fg $DefaultFG -bg $DefaultBG \
                      -activeforeground $DefaultAFG \
                      -activebackground $DefaultABG \
                      -bd 4 -width 10 -command "HandleRQ $messTag"

  pack ${messTag}.ok -side top -ipadx 2m -ipady 1m -pady 2m \
                               -expand 1 -in ${messTag}.frame
  bind ${messTag} <Return> "HandleRQ $messTag"

  focus -force ${messTag}.ok

  tkwait window ${messTag}
};
# -------------------------------------------------------------------------
# Function    : GetFileName { parentWidget entryWidget fileType }
#
# Description : This procedure displays a dialog box for a RIB
#               file, and fills 'entryWidget' with the selection.
#
# Parameters  : parentFrame : Parent frame.
#               entryWidget : Entry widget to add file to.
#               fileOp      : Operation: "open" or "save"
#               fileType    : One of: RIB or AIFF
#
# Returns     : Selected file(s).

proc GetFileName { parentWidget entryWidget fileOp fileType }  {
  #   Type names		Extension(s)	Mac File Type(s)
  #
  #---------------------------------------------------------
  if { $fileType == "RIB" }  {
    set types {
        {"RIB files"		{.rib}	        TEXT}
        {"All files"		{*}                 }
    }
  } else  {
    set types {
        {"AIFF files"		{.aiff}	        TEXT}
        {"All files"		{*}                 }
    }
  }
  if { $fileOp == "open" }  {
    set file [ tk_getOpenFile -filetypes $types -parent $parentWidget ]
  } else {
    if { $fileOp == "save" }  {
      set file [ tk_getSaveFile -filetypes $types -parent $parentWidget ]
    } else {
      set file [ tk_getOpenDir -filetypes $types -parent $parentWidget ]
    }
  }
  if [ string compare $file "" ]  {
    $entryWidget delete 0 end
    $entryWidget insert 0 $file
    $entryWidget xview end
  }
}

# -------------------------------------------------------------------------

proc tk_getOpenDir { args }  {
  tkDDialog $args dir
}
# -------------------------------------------------------------------------
# Function    : BuildCmdLine { }
#
# Description : This procedure constructs the command line to start the
#               rendering process.
#
# Parameters  : void.
#
# Returns     : void.

proc BuildCmdLine { }  {
  global CurRenderer
  global CurSource
  global CurRIBSource
  global Rendrib
  global RGL
  global CmdLine

  switch -regexp -- $CurRenderer  { \
    ^rendrib$  {
      set renderArgs ""

      # Resolution
      if { ( [ string length [ string trim $Rendrib(ResX) ] ] > 0 ) && \
           ( [ string length [ string trim $Rendrib(ResY) ] ] > 0 ) }  {
        set renderArgs [ format "%s -res %d %d" $renderArgs \
              [ string trim $Rendrib(ResX) ] \
              [ string trim $Rendrib(ResY) ] ]
      }
      # Samples
      if { ( [ string length [ string trim $Rendrib(SamplesX) ] ] > 0 ) && \
           ( [ string length [ string trim $Rendrib(SamplesY) ] ] > 0 ) }  {
        set renderArgs [ format "%s -samples %d %d" $renderArgs \
              [ string trim $Rendrib(SamplesX) ] \
              [ string trim $Rendrib(SamplesY) ] ]
      }
      # Variance Sampling
      if { ( [ string length [ string trim $Rendrib(VarV) ] ] > 0 ) && \
           ( [ string length [ string trim $Rendrib(VarMin) ] ] > 0 ) && \
           ( [ string length [ string trim $Rendrib(VarMax) ] ] > 0 ) }  {
        set renderArgs [ format "%s -var %f %d %d" $renderArgs \
              [ string trim $Rendrib(VarV) ] \
              [ string trim $Rendrib(VarMin) ] \
              [ string trim $Rendrib(VarMax) ] ]
      }
      # Frames
      if { ( [ string length [ string trim $Rendrib(StartFrame) ] ] > 0 ) && \
           ( [ string length [ string trim $Rendrib(EndFrame) ] ] > 0 ) }  {
        set renderArgs [ format "%s -frames %d %d" $renderArgs \
              [ string trim $Rendrib(StartFrame) ] \
              [ string trim $Rendrib(EndFrame) ] ]
      }
      # Radiosity Steps
      if { [ string length [ string trim $Rendrib(RadioSteps) ] ] > 0 }  {
        set renderArgs [ format "%s -radio %d" $renderArgs \
              [ string trim $Rendrib(RadioSteps) ] ]
      }
      # Radiosity Samples
      if { [ string length [ string trim $Rendrib(RadioSamples) ] ] > 0 }  {
        set renderArgs [ format "%s -rsamples %d" $renderArgs \
              [ string trim $Rendrib(RadioSamples) ] ]
      }
      # Crop Window
      if { ( [ string length [ string trim $Rendrib(CropX1) ] ] > 0 ) && \
           ( [ string length [ string trim $Rendrib(CropY1) ] ] > 0 ) && \
           ( [ string length [ string trim $Rendrib(CropX2) ] ] > 0 ) && \
           ( [ string length [ string trim $Rendrib(CropY2) ] ] > 0 ) }  {
        set renderArgs [ format "%s -crop %f %f %f %f" $renderArgs \
              [ string trim $Rendrib(CropX1) ] \
              [ string trim $Rendrib(CropY1) ] \
              [ string trim $Rendrib(CropX2) ] \
              [ string trim $Rendrib(CropY2) ] ]
      }
      # Safe Mode
      if { $Rendrib(Safe) == 1 }  {
        set renderArgs [ format "%s -safe" $renderArgs ]
      }
      # Display Image
      if { $Rendrib(Display) == 1 }  {
        set renderArgs [ format "%s -d" $renderArgs ]
        # Interlace?
        if { [ string length [ string trim $Rendrib(DispInterlace) ] ] > 0 }  {
          set renderArgs [ format "%s %d" $renderArgs \
                [ string trim $Rendrib(DispInterlace) ] ]
        }
      }
      # Position
      if { ( [ string length [ string trim $Rendrib(PosX) ] ] > 0 ) && \
           ( [ string length [ string trim $Rendrib(PosY) ] ] > 0 ) }  {
        set renderArgs [ format "%s -pos %d %d" $renderArgs \
              [ string trim $Rendrib(PosX) ] \
              [ string trim $Rendrib(PosY) ] ]
      }
      # ASCII Preview
      if { $Rendrib(Ascii) == 1 }  {
        set renderArgs [ format "%s -ascii" $renderArgs ]
      }
      # Verbose
      if { $Rendrib(Verbose) == 1 }  {
        set renderArgs [ format "%s -v" $renderArgs ]
      }
      # Stats
      if { $Rendrib(Stats) == 1 }  {
        set renderArgs [ format "%s -stats" $renderArgs ]
      }
      # Silent
      if { $Rendrib(Silent) == 1 }  {
        set renderArgs [ format "%s -silent" $renderArgs ]
      }
      # Ray Server
      if { $Rendrib(Rayserver) == 1 }  {
        set renderArgs [ format "%s -rayserver" $renderArgs ]
      }
    }
    ^rgl$      {
      set renderArgs ""

      # Resolution
      if { ( [ string length [ string trim $RGL(ResX) ] ] > 0 ) && \
           ( [ string length [ string trim $RGL(ResY) ] ] > 0 ) }  {
        set renderArgs [ format "%s -res %d %d" $renderArgs \
              [ string trim $RGL(ResX) ] \
              [ string trim $RGL(ResY) ] ]
      }
      # Position
      if { ( [ string length [ string trim $RGL(PosX) ] ] > 0 ) && \
           ( [ string length [ string trim $RGL(PosY) ] ] > 0 ) }  {
        set renderArgs [ format "%s -pos %d %d" $renderArgs \
              [ string trim $RGL(PosX) ] \
              [ string trim $RGL(PosY) ] ]
      }
      # Frames
      if { ( [ string length [ string trim $RGL(StartFrame) ] ] > 0 ) && \
           ( [ string length [ string trim $RGL(EndFrame) ] ] > 0 ) }  {
        set renderArgs [ format "%s -frames %d %d" $renderArgs \
              [ string trim $RGL(StartFrame) ] \
              [ string trim $RGL(EndFrame) ] ]
      }
      # Crop Window
      if { ( [ string length [ string trim $RGL(CropX1) ] ] > 0 ) && \
           ( [ string length [ string trim $RGL(CropY1) ] ] > 0 ) && \
           ( [ string length [ string trim $RGL(CropX2) ] ] > 0 ) && \
           ( [ string length [ string trim $RGL(CropY2) ] ] > 0 ) }  {
        set renderArgs [ format "%s -crop %f %f %f %f" $renderArgs \
              [ string trim $RGL(CropX1) ] \
              [ string trim $RGL(CropY1) ] \
              [ string trim $RGL(CropX2) ] \
              [ string trim $RGL(CropY2) ] ]
      }
      # Sync
      if { [ string length [ string trim $RGL(SyncN) ] ] > 0 }  {
        set renderArgs [ format "%s -sync %d" $renderArgs \
              [ string trim $RGL(SyncN) ] ]
      }
      # Rendering Detail
      if { [ string length [ string trim $RGL(Detail) ] ] > 0 }  {
        set renderArgs [ format "%s -rd %f" $renderArgs \
              [ string trim $RGL(Detail) ] ]
      }
      # Frame Command
      if { [ string length [ string trim $RGL(FrameCommand) ] ] > 0 }  {
        set renderArgs [ format "%s -fc %s" $renderArgs \
              [ string trim $RGL(FrameCommand) ] ]
      }
      # No Wait
      if { $RGL(NoWait) == 1 }  {
        set renderArgs [ format "%s -nowait" $renderArgs ]
      }
      # Wireframe
      if { $RGL(Wireframe) == 1 }  {
        set renderArgs [ format "%s -lines" $renderArgs ]
      }
      # Ignore Lights
      if { $RGL(IgnoreLights) == 1 }  {
        set renderArgs [ format "%s -unlit" $renderArgs ]
      }
      # Stats
      if { $RGL(Stats) == 1 }  {
        set renderArgs [ format "%s -stats" $renderArgs ]
      }
      # Single-Buffer
      if { $RGL(1Buffer) == 1 }  {
        set renderArgs [ format "%s -1buffer" $renderArgs ]
      }
      # Sketch
      if { $RGL(Sketch) == 1 }  {
        set renderArgs [ format "%s -sketch" $renderArgs ]
      }
      # Dump RGB
      if { $RGL(DumpRGB) == 1 }  {
        set renderArgs [ format "%s -dumprgba" $renderArgs ]
      }
      if { $RGL(DumpRGB) == 2 }  {
        set renderArgs [ format "%s -dumprgbaz" $renderArgs ]
      }
      # Display Image
      if { $RGL(Display) == 0 }  {
        set renderArgs [ format "%s -offscreen" $renderArgs ]
      }
      # Verbose
      if { $RGL(Verbose) == 1 }  {
        set renderArgs [ format "%s -v" $renderArgs ]
      }
      # Sound File
      if { [ string length [ string trim $RGL(SoundFile) ] ] > 0 }  {
        set renderArgs [ format "%s -sound %s" $renderArgs \
              [ string trim $RGL(SoundFile) ] ]
      }
    }
  }
  set CmdLine [ string trim $renderArgs ]
#puts "$CmdLine"
}
# -------------------------------------------------------------------------
# Function    : BuildRendribLayout { thisMenu }
#
# Description : This procedure constructs the geometry for data entry
#               for the rendrib parameters, and returns it.
#
# Parameters  : thisMenu : Tag to use for the menu.
#
# Returns     : Full tag of created geometry.

proc BuildRendribLayout { thisMenu }  {
  global DefaultFont
  global DefaultFG
  global DefaultBG
  global DefaultMenuFG
  global DefaultMenuBG
  global DefaultMenuAFG
  global DefaultMenuABG
  global DefaultMenuSBG
  global DefaultEntryFG
  global DefaultEntryBG
  global TitleFG
  global TitleBG
  global PromptFont
  global EntryFont
  global Rendrib
  global tcl_platform
  set dummy "   "
  set dummy1 "  "
  set dummy2 "    "
  set dummy3 ""
  set promptWidth 20

  frame ${thisMenu} -relief raised -bg $DefaultBG
  # Make some frames for grouping the sub-panes.
  frame ${thisMenu}.tFrame1 -relief flat
  frame ${thisMenu}.tFrame2 -relief flat

  # ---------------------------------------------
  # Build the widgets for the Image-specific parameters
  frame ${thisMenu}.imageFrame -relief raised -bg $DefaultBG -bd 1
  frame ${thisMenu}.iValueFrame -relief flat -bg $DefaultBG

  frame ${thisMenu}.resFrame    -relief flat -bg $DefaultBG
  frame ${thisMenu}.crop1Frame  -relief flat -bg $DefaultBG
  frame ${thisMenu}.crop2Frame     -relief flat -bg $DefaultBG
  frame ${thisMenu}.startFrame     -relief flat -bg $DefaultBG
  frame ${thisMenu}.endFrame       -relief flat -bg $DefaultBG
  frame ${thisMenu}.dispFrame      -relief flat -bg $DefaultBG
  frame ${thisMenu}.interlaceFrame -relief flat -bg $DefaultBG
  frame ${thisMenu}.posFrame       -relief flat -bg $DefaultBG

  # Title
  label ${thisMenu}.imageTitle -font $DefaultFont -anchor c \
        -fg $TitleFG -bg $TitleBG -bd 2 -relief raised \
        -text "Image Parameters"

  # These are the Prompts
  # Resolution
  label ${thisMenu}.resPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Resolution:"

  frame ${thisMenu}.resValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.resXValPrompt -relief flat -text " X:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.resYValPrompt -relief flat -text "  Y:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.resXValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(ResX) -font $EntryFont
  entry ${thisMenu}.resYValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(ResY) -font $EntryFont

  pack ${thisMenu}.resXValPrompt ${thisMenu}.resXValEntry \
       ${thisMenu}.resYValPrompt ${thisMenu}.resYValEntry \
       -side left -in ${thisMenu}.resValFrame

  pack ${thisMenu}.resPrompt ${thisMenu}.resValFrame \
       -side left -in ${thisMenu}.resFrame

  # Crop Window
  label ${thisMenu}.cropPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Crop Window:"

  frame ${thisMenu}.cropValFrame1 -relief flat -bg $DefaultBG
  label ${thisMenu}.cropXValPrompt1 -relief flat -text "X1:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.cropYValPrompt1 -relief flat -text " Y1:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.cropXValEntry1 -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(CropX1) -font $EntryFont
  entry ${thisMenu}.cropYValEntry1 -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(CropY1) -font $EntryFont

  pack ${thisMenu}.cropXValPrompt1 ${thisMenu}.cropXValEntry1 \
       ${thisMenu}.cropYValPrompt1 ${thisMenu}.cropYValEntry1 \
       -side left -fill x -in ${thisMenu}.cropValFrame1

  pack ${thisMenu}.cropPrompt ${thisMenu}.cropValFrame1 \
       -side left -in ${thisMenu}.crop1Frame

  label ${thisMenu}.cropDummy -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text " "

  frame ${thisMenu}.cropValFrame2 -relief flat -bg $DefaultBG
  label ${thisMenu}.cropXValPrompt2 -relief flat -text "X2:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.cropYValPrompt2 -relief flat -text " Y2:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.cropXValEntry2 -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(CropX2) -font $EntryFont
  entry ${thisMenu}.cropYValEntry2 -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(CropY2) -font $EntryFont

  pack ${thisMenu}.cropXValPrompt2 ${thisMenu}.cropXValEntry2 \
       ${thisMenu}.cropYValPrompt2 ${thisMenu}.cropYValEntry2 \
       -side left -fill x -in ${thisMenu}.cropValFrame2

  pack ${thisMenu}.cropDummy ${thisMenu}.cropValFrame2 \
       -side left -in ${thisMenu}.crop2Frame

  # Start Frame
  label ${thisMenu}.startPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Start Frame:"

  frame ${thisMenu}.startValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.startValPrompt -relief flat -text $dummy \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.startValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(StartFrame) -font $EntryFont

  pack ${thisMenu}.startValPrompt ${thisMenu}.startValEntry \
       -side left -fill x -in ${thisMenu}.startValFrame

  pack ${thisMenu}.startPrompt ${thisMenu}.startValFrame \
       -side left -in ${thisMenu}.startFrame

  # End Frame
  label ${thisMenu}.endPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "End Frame:"

  frame ${thisMenu}.endValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.endValPrompt -relief flat -text $dummy \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.endValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(EndFrame) -font $EntryFont

  pack ${thisMenu}.endValPrompt ${thisMenu}.endValEntry \
       -side left -fill x -in ${thisMenu}.endValFrame

  pack ${thisMenu}.endPrompt ${thisMenu}.endValFrame \
       -side left -in ${thisMenu}.endFrame

  # Display Window
  label ${thisMenu}.dispPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Render to Window?"

  frame ${thisMenu}.dispValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.dispValPrompt -relief flat -text $dummy \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.dispValCheck -variable Rendrib(Display) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.dispValPrompt ${thisMenu}.dispValCheck \
       -side left -fill x -in ${thisMenu}.dispValFrame

  pack ${thisMenu}.dispPrompt ${thisMenu}.dispValFrame \
       -side left -in ${thisMenu}.dispFrame

  # Display Interlace
  label ${thisMenu}.interlacePrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "  Interlace:"

  frame ${thisMenu}.interValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.interValPrompt -relief flat -text $dummy \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.interValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(DispInterlace) -font $EntryFont

  pack ${thisMenu}.interValPrompt ${thisMenu}.interValEntry \
       -side left -fill x -in ${thisMenu}.interValFrame

  pack ${thisMenu}.interlacePrompt ${thisMenu}.interValFrame \
       -side left -in ${thisMenu}.interlaceFrame

  # Window Position
  label ${thisMenu}.posPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "  Window Position:"

  frame ${thisMenu}.posValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.posXValPrompt -relief flat -text " X:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.posYValPrompt -relief flat -text "  Y:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.posXValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(PosX) -font $EntryFont
  entry ${thisMenu}.posYValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable Rendrib(PosY) -font $EntryFont

  pack ${thisMenu}.posXValPrompt ${thisMenu}.posXValEntry \
       ${thisMenu}.posYValPrompt ${thisMenu}.posYValEntry \
       -side left -in ${thisMenu}.posValFrame

  pack ${thisMenu}.posPrompt ${thisMenu}.posValFrame \
       -side left -in ${thisMenu}.posFrame

  pack ${thisMenu}.resFrame \
       ${thisMenu}.crop1Frame \
       ${thisMenu}.crop2Frame \
       ${thisMenu}.startFrame \
       ${thisMenu}.endFrame \
       ${thisMenu}.dispFrame \
       ${thisMenu}.interlaceFrame \
       ${thisMenu}.posFrame \
       -side top -fill x -in ${thisMenu}.iValueFrame

  pack ${thisMenu}.imageTitle \
       -side top -fill x -in ${thisMenu}.imageFrame

  pack ${thisMenu}.iValueFrame \
       -side left -in ${thisMenu}.imageFrame

  # ---------------------------------------------
  # Build the widgets for the Radiosity-specific parameters
  frame ${thisMenu}.radioFrame  -relief raised -bg $DefaultBG -bd 1
  frame ${thisMenu}.rValueFrame -relief flat -bg $DefaultBG

  frame ${thisMenu}.stepsFrame    -relief flat -bg $DefaultBG
  frame ${thisMenu}.rsamplesFrame -relief flat -bg $DefaultBG

  # Title
  label ${thisMenu}.radioTitle -font $DefaultFont -anchor c \
        -fg $TitleFG -bg $TitleBG -bd 2 -relief raised \
        -text "Radiosity Parameters"

  # These are the Prompts
  # Steps
  label ${thisMenu}.stepsPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Steps:"

  frame ${thisMenu}.stepsValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.stepsValPrompt -relief flat -text $dummy \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.stepsValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 3 -textvariable Rendrib(RadioSteps) -font $EntryFont

  pack ${thisMenu}.stepsValPrompt ${thisMenu}.stepsValEntry \
       -side left -in ${thisMenu}.stepsValFrame

  pack ${thisMenu}.stepsPrompt ${thisMenu}.stepsValFrame \
       -side left -in ${thisMenu}.stepsFrame

  # Ray Samples
  label ${thisMenu}.rsamplesPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Ray Samples:"

  frame ${thisMenu}.rsamplesValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.rsamplesValPrompt -relief flat -text $dummy \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.rsamplesValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 3 -textvariable Rendrib(RadioSamples) -font $EntryFont

  pack ${thisMenu}.rsamplesValPrompt ${thisMenu}.rsamplesValEntry \
       -side left -in ${thisMenu}.rsamplesValFrame

  pack ${thisMenu}.rsamplesPrompt ${thisMenu}.rsamplesValFrame \
       -side left -in ${thisMenu}.rsamplesFrame

  pack ${thisMenu}.stepsFrame \
       ${thisMenu}.rsamplesFrame \
       -side top -fill x -in ${thisMenu}.rValueFrame

  pack ${thisMenu}.radioTitle \
       -side top -fill x -in ${thisMenu}.radioFrame

  pack ${thisMenu}.rValueFrame \
       -side left -in ${thisMenu}.radioFrame

  # ---------------------------------------------
  # Build the widgets for the Sampling-specific parameters
  frame ${thisMenu}.sampleFrame -relief raised -bg $DefaultBG -bd 1
  frame ${thisMenu}.sValueFrame -relief flat -bg $DefaultBG

  frame ${thisMenu}.sppFrame   -relief flat -bg $DefaultBG
  frame ${thisMenu}.varFrame   -relief flat -bg $DefaultBG
  frame ${thisMenu}.varmmFrame -relief flat -bg $DefaultBG

  # Title
  label ${thisMenu}.sampleTitle -font $DefaultFont -anchor c \
        -fg $TitleFG -bg $TitleBG -bd 2 -relief raised \
        -text "Sampling Parameters"

  # These are the Prompts
  # Samples per Pixel
  label ${thisMenu}.sppPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Samples/Pixel:"

  frame ${thisMenu}.sppValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.sppXValPrompt -relief flat -text "  X:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.sppYValPrompt -relief flat -text "  Y:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.sppXValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 3 -textvariable Rendrib(SamplesX) -font $EntryFont
  entry ${thisMenu}.sppYValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 3 -textvariable Rendrib(SamplesY) -font $EntryFont

  pack ${thisMenu}.sppXValPrompt ${thisMenu}.sppXValEntry \
       ${thisMenu}.sppYValPrompt ${thisMenu}.sppYValEntry \
       -side left -in ${thisMenu}.sppValFrame

  pack ${thisMenu}.sppPrompt ${thisMenu}.sppValFrame \
       -side left -in ${thisMenu}.sppFrame

  # Variance
  label ${thisMenu}.varPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Max. Variance:"

  frame ${thisMenu}.varValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.varValPrompt -relief flat -text $dummy2 \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.varValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 3 -textvariable Rendrib(VarV) -font $EntryFont

  pack ${thisMenu}.varValPrompt ${thisMenu}.varValEntry \
       -side left -in ${thisMenu}.varValFrame

  pack ${thisMenu}.varPrompt ${thisMenu}.varValFrame \
       -side left -in ${thisMenu}.varFrame

  # Variance Min/Max
  label ${thisMenu}.varmmPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "  Samples:"

  frame ${thisMenu}.varmmValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.var1ValPrompt -relief flat -text "Min:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.var2ValPrompt -relief flat -text "Max:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.var1ValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 3 -textvariable Rendrib(VarMin) -font $EntryFont
  entry ${thisMenu}.var2ValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 3 -textvariable Rendrib(VarMax) -font $EntryFont

  pack ${thisMenu}.var1ValPrompt ${thisMenu}.var1ValEntry \
       ${thisMenu}.var2ValPrompt ${thisMenu}.var2ValEntry \
       -side left -in ${thisMenu}.varmmValFrame

  pack ${thisMenu}.varmmPrompt ${thisMenu}.varmmValFrame \
       -side left -in ${thisMenu}.varmmFrame

  pack ${thisMenu}.sppFrame \
       ${thisMenu}.varFrame \
       ${thisMenu}.varmmFrame \
       -side top -fill x -in ${thisMenu}.sValueFrame

  pack ${thisMenu}.sampleTitle \
       -side top -fill x -in ${thisMenu}.sampleFrame

  pack ${thisMenu}.sValueFrame \
       -side left -in ${thisMenu}.sampleFrame

  # ---------------------------------------------
  # Build the widgets for the Miscellaneous parameters
  frame ${thisMenu}.miscFrame -relief raised -bg $DefaultBG -bd 1
  frame ${thisMenu}.mValueFrame -relief flat -bg $DefaultBG

  frame ${thisMenu}.safeFrame    -relief flat -bg $DefaultBG
  frame ${thisMenu}.asciiFrame   -relief flat -bg $DefaultBG
  frame ${thisMenu}.verboseFrame -relief flat -bg $DefaultBG
  frame ${thisMenu}.statsFrame   -relief flat -bg $DefaultBG

  # Title
  label ${thisMenu}.miscTitle -font $DefaultFont -anchor c \
        -fg $TitleFG -bg $TitleBG -bd 2 -relief raised \
        -text "Miscellaneous Parameters"

  # These are the Prompts
  # Safe Mode
  label ${thisMenu}.safePrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Protect Existing Frames?"

  frame ${thisMenu}.safeValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.safeValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.safeValCheck -variable Rendrib(Safe) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.safeValPrompt ${thisMenu}.safeValCheck \
       -side left -fill x -in ${thisMenu}.safeValFrame

  pack ${thisMenu}.safePrompt ${thisMenu}.safeValFrame \
       -side left -in ${thisMenu}.safeFrame

  # Output ASCII Preview
  label ${thisMenu}.asciiPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Output ASCII Preview?"

  frame ${thisMenu}.asciiValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.asciiValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.asciiValCheck -variable Rendrib(Ascii) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.asciiValPrompt ${thisMenu}.asciiValCheck \
       -side left -fill x -in ${thisMenu}.asciiValFrame

  pack ${thisMenu}.asciiPrompt ${thisMenu}.asciiValFrame \
       -side left -in ${thisMenu}.asciiFrame

  # Be Verbose
  label ${thisMenu}.verbosePrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Run in Verbose Mode?"

  frame ${thisMenu}.verboseValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.verboseValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.verboseValCheck -variable Rendrib(Verbose) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.verboseValPrompt ${thisMenu}.verboseValCheck \
       -side left -fill x -in ${thisMenu}.verboseValFrame

  pack ${thisMenu}.verbosePrompt ${thisMenu}.verboseValFrame \
       -side left -in ${thisMenu}.verboseFrame

  # Stats
  label ${thisMenu}.statsPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Output Statistics?"

  frame ${thisMenu}.statsValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.statsValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.statsValCheck -variable Rendrib(Stats) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.statsValPrompt ${thisMenu}.statsValCheck \
       -side left -fill x -in ${thisMenu}.statsValFrame

  pack ${thisMenu}.statsPrompt ${thisMenu}.statsValFrame \
       -side left -in ${thisMenu}.statsFrame

  pack ${thisMenu}.safeFrame \
       ${thisMenu}.asciiFrame \
       ${thisMenu}.verboseFrame \
       ${thisMenu}.statsFrame \
       -side top -fill x -in ${thisMenu}.mValueFrame

  pack ${thisMenu}.miscTitle \
       -side top -fill x -in ${thisMenu}.miscFrame

  pack ${thisMenu}.mValueFrame \
       -side left -in ${thisMenu}.miscFrame

  pack ${thisMenu}.imageFrame \
       ${thisMenu}.radioFrame \
       -side top -fill x -in ${thisMenu}.tFrame1

  pack ${thisMenu}.sampleFrame \
       ${thisMenu}.miscFrame \
       -side top -fill x -in ${thisMenu}.tFrame2

  pack ${thisMenu}.tFrame1 \
       ${thisMenu}.tFrame2 \
       -side left -fill y -in ${thisMenu}

  return $thisMenu
};

# -------------------------------------------------------------------------
# Function    : BuildRGLLayout { thisMenu }
#
# Description : This procedure constructs the geometry for data entry
#               for the rgl parameters, and returns it.
#
# Parameters  : thisMenu : Tag to use for the menu.
#
# Returns     : Full tag of created geometry.

proc BuildRGLLayout { thisMenu }  {
  global DefaultFont
  global DefaultFG
  global DefaultBG
  global DefaultMenuFG
  global DefaultMenuBG
  global DefaultMenuAFG
  global DefaultMenuABG
  global DefaultMenuSBG
  global DefaultEntryFG
  global DefaultEntryBG
  global TitleFG
  global TitleBG
  global PromptFont
  global EntryFont
  global RGL
  global tcl_platform
  set dummy1 "   "
  set dummy2 ""
  set promptWidth 20

  frame ${thisMenu} -relief raised -bg $DefaultBG
  # Make some frames for grouping the sub-panes.
  frame ${thisMenu}.tFrame1 -relief flat
  frame ${thisMenu}.tFrame2 -relief flat

  # ---------------------------------------------
  # Build the widgets for the Image-specific parameters
  frame ${thisMenu}.imageFrame -relief raised -bg $DefaultBG -bd 1
  frame ${thisMenu}.iValueFrame -relief flat -bg $DefaultBG

  frame ${thisMenu}.resFrame    -relief flat -bg $DefaultBG
  frame ${thisMenu}.crop1Frame  -relief flat -bg $DefaultBG
  frame ${thisMenu}.crop2Frame  -relief flat -bg $DefaultBG
  frame ${thisMenu}.startFrame  -relief flat -bg $DefaultBG
  frame ${thisMenu}.endFrame    -relief flat -bg $DefaultBG
  frame ${thisMenu}.dispFrame   -relief flat -bg $DefaultBG
  frame ${thisMenu}.posFrame    -relief flat -bg $DefaultBG
  frame ${thisMenu}.wireFrame   -relief flat -bg $DefaultBG
  frame ${thisMenu}.sketchFrame -relief flat -bg $DefaultBG
  frame ${thisMenu}.lightsFrame -relief flat -bg $DefaultBG
  frame ${thisMenu}.detailFrame -relief flat -bg $DefaultBG

  # Title
  label ${thisMenu}.imageTitle -font $DefaultFont -anchor c \
        -fg $TitleFG -bg $TitleBG -bd 2 -relief raised \
        -text "Image Parameters"

  # These are the parameters.
  # Resolution
  label ${thisMenu}.resPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Resolution:"

  frame ${thisMenu}.resValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.resXValPrompt -relief flat -text " X:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.resYValPrompt -relief flat -text "  Y:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.resXValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(ResX) -font $EntryFont
  entry ${thisMenu}.resYValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(ResY) -font $EntryFont
  pack ${thisMenu}.resXValPrompt ${thisMenu}.resXValEntry \
       ${thisMenu}.resYValPrompt ${thisMenu}.resYValEntry \
       -side left -in ${thisMenu}.resValFrame

  pack ${thisMenu}.resPrompt ${thisMenu}.resValFrame \
       -side left -in ${thisMenu}.resFrame

  # Crop Window
  label ${thisMenu}.cropPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Crop Window:"
  label ${thisMenu}.cropDummy -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text " "

  frame ${thisMenu}.cropValFrame1 -relief flat -bg $DefaultBG
  label ${thisMenu}.cropXValPrompt1 -relief flat -text "X1:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.cropYValPrompt1 -relief flat -text " Y1:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.cropXValEntry1 -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(CropX1) -font $EntryFont
  entry ${thisMenu}.cropYValEntry1 -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(CropY1) -font $EntryFont

  pack ${thisMenu}.cropXValPrompt1 ${thisMenu}.cropXValEntry1 \
       ${thisMenu}.cropYValPrompt1 ${thisMenu}.cropYValEntry1 \
       -side left -fill x -in ${thisMenu}.cropValFrame1

  pack ${thisMenu}.cropPrompt ${thisMenu}.cropValFrame1 \
       -side left -in ${thisMenu}.crop1Frame

  frame ${thisMenu}.cropValFrame2 -relief flat -bg $DefaultBG
  label ${thisMenu}.cropXValPrompt2 -relief flat -text "X2:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.cropYValPrompt2 -relief flat -text " Y2:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.cropXValEntry2 -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(CropX2) -font $EntryFont
  entry ${thisMenu}.cropYValEntry2 -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(CropY2) -font $EntryFont

  pack ${thisMenu}.cropXValPrompt2 ${thisMenu}.cropXValEntry2 \
       ${thisMenu}.cropYValPrompt2 ${thisMenu}.cropYValEntry2 \
       -side left -fill x -in ${thisMenu}.cropValFrame2

  pack ${thisMenu}.cropDummy ${thisMenu}.cropValFrame2 \
       -side left -in ${thisMenu}.crop2Frame

  # Start Frame
  label ${thisMenu}.startPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Start Frame:"

  frame ${thisMenu}.startValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.startValPrompt -relief flat -text $dummy1 \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.startValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(StartFrame) -font $EntryFont

  pack ${thisMenu}.startValPrompt ${thisMenu}.startValEntry \
       -side left -fill x -in ${thisMenu}.startValFrame

  pack ${thisMenu}.startPrompt ${thisMenu}.startValFrame \
       -side left -in ${thisMenu}.startFrame

  # End Frame
  label ${thisMenu}.endPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "End Frame:"

  frame ${thisMenu}.endValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.endValPrompt -relief flat -text $dummy1 \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.endValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(EndFrame) -font $EntryFont

  pack ${thisMenu}.endValPrompt ${thisMenu}.endValEntry \
       -side left -fill x -in ${thisMenu}.endValFrame

  pack ${thisMenu}.endPrompt ${thisMenu}.endValFrame \
       -side left -in ${thisMenu}.endFrame

  # Display Window checkbox
  label ${thisMenu}.dispPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Render to Window?"

  frame ${thisMenu}.dispValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.dispValPrompt -relief flat -text $dummy1 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.dispValCheck -variable RGL(Display) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.dispValPrompt ${thisMenu}.dispValCheck \
       -side left -fill x -in ${thisMenu}.dispValFrame

  pack ${thisMenu}.dispPrompt ${thisMenu}.dispValFrame \
       -side left -in ${thisMenu}.dispFrame

  # Display Window Position
  label ${thisMenu}.posPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "  Window Position:"

  frame ${thisMenu}.posValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.posXValPrompt -relief flat -text " X:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  label ${thisMenu}.posYValPrompt -relief flat -text "  Y:" \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.posXValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(PosX) -font $EntryFont
  entry ${thisMenu}.posYValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(PosY) -font $EntryFont

  pack ${thisMenu}.posXValPrompt ${thisMenu}.posXValEntry \
       ${thisMenu}.posYValPrompt ${thisMenu}.posYValEntry \
       -side left -in ${thisMenu}.posValFrame

  pack ${thisMenu}.posPrompt ${thisMenu}.posValFrame \
       -side left -in ${thisMenu}.posFrame

  # Display in Wireframe mode?
  label ${thisMenu}.wirePrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Render in Wireframe?"

  frame ${thisMenu}.wireValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.wireValPrompt -relief flat -text $dummy1 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.wireValCheck -variable RGL(Wireframe) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.wireValPrompt ${thisMenu}.wireValCheck \
       -side left -fill x -in ${thisMenu}.wireValFrame

  pack ${thisMenu}.wirePrompt ${thisMenu}.wireValFrame \
       -side left -in ${thisMenu}.wireFrame

  # Sketch
  label ${thisMenu}.sketchPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Render as a Sketch?"

  frame ${thisMenu}.sketchValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.sketchValPrompt -relief flat -text $dummy1 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.sketchValCheck -variable RGL(Sketch) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.sketchValPrompt ${thisMenu}.sketchValCheck \
       -side left -fill x -in ${thisMenu}.sketchValFrame

  pack ${thisMenu}.sketchPrompt ${thisMenu}.sketchValFrame \
       -side left -in ${thisMenu}.sketchFrame

  # Ignore Lights?
  label ${thisMenu}.lightsPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Ignore Defined Lights?"

  frame ${thisMenu}.lightsValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.lightsValPrompt -relief flat -text $dummy1 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.lightsValCheck -variable RGL(Lightsframe) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.lightsValPrompt ${thisMenu}.lightsValCheck \
       -side left -fill x -in ${thisMenu}.lightsValFrame

  pack ${thisMenu}.lightsPrompt ${thisMenu}.lightsValFrame \
       -side left -in ${thisMenu}.lightsFrame

  # Render Detail
  label ${thisMenu}.detailPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Render Detail:"

  frame ${thisMenu}.detailValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.detailValPrompt -relief flat -text $dummy1 \
        -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.detailValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(Detail) -font $EntryFont

  pack ${thisMenu}.detailValPrompt ${thisMenu}.detailValEntry \
       -side left -fill x -in ${thisMenu}.detailValFrame

  pack ${thisMenu}.detailPrompt ${thisMenu}.detailValFrame \
       -side left -in ${thisMenu}.detailFrame

  pack ${thisMenu}.resFrame \
       ${thisMenu}.crop1Frame \
       ${thisMenu}.crop2Frame \
       ${thisMenu}.startFrame \
       ${thisMenu}.endFrame \
       ${thisMenu}.dispFrame \
       ${thisMenu}.posFrame \
       ${thisMenu}.wireFrame \
       ${thisMenu}.sketchFrame \
       ${thisMenu}.lightsFrame \
       ${thisMenu}.detailFrame \
       -side top -fill x -in ${thisMenu}.iValueFrame

  pack ${thisMenu}.imageTitle \
       -side top -fill x -in ${thisMenu}.imageFrame

  pack ${thisMenu}.iValueFrame \
       -side left -in ${thisMenu}.imageFrame

  # ---------------------------------------------
  # Build the widgets for the Miscellaneous parameters
  frame ${thisMenu}.miscFrame -relief raised -bg $DefaultBG -bd 1
  frame ${thisMenu}.mValueFrame -relief flat -bg $DefaultBG

  frame ${thisMenu}.fpsFrame     -relief flat -bg $DefaultBG
  frame ${thisMenu}.fcFrame      -relief flat -bg $DefaultBG
  frame ${thisMenu}.verboseFrame -relief flat -bg $DefaultBG
  frame ${thisMenu}.statsFrame   -relief flat -bg $DefaultBG
  frame ${thisMenu}.1bufferFrame -relief flat -bg $DefaultBG
  frame ${thisMenu}.exitFrame    -relief flat -bg $DefaultBG
  frame ${thisMenu}.dumpFrame    -relief flat -bg $DefaultBG
  if { $tcl_platform(platform) == "unix" }  {
    frame ${thisMenu}.soundFrame -relief flat -bg $DefaultBG
  }

  # Title
  label ${thisMenu}.miscTitle -font $DefaultFont -anchor c \
        -fg $TitleFG -bg $TitleBG -bd 2 -relief raised \
        -text "Miscellaneous Parameters"

  # These are the Prompts
  # Sync
  label ${thisMenu}.fpsPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Frames/Second:"

  frame ${thisMenu}.fpsValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.fpsValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.fpsValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 5 -textvariable RGL(SyncN) -font $EntryFont

  pack ${thisMenu}.fpsValPrompt ${thisMenu}.fpsValEntry \
       -side left -fill x -in ${thisMenu}.fpsValFrame

  pack ${thisMenu}.fpsPrompt ${thisMenu}.fpsValFrame \
       -side left -in ${thisMenu}.fpsFrame

  # Frame Command
  label ${thisMenu}.fcPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Frame Command:"

  frame ${thisMenu}.fcValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.fcValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  entry ${thisMenu}.fcValEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 14 -textvariable RGL(FrameCommand) -font $EntryFont

  pack ${thisMenu}.fcValPrompt ${thisMenu}.fcValEntry \
       -side left -fill x -in ${thisMenu}.fcValFrame

  pack ${thisMenu}.fcPrompt ${thisMenu}.fcValFrame \
       -side left -in ${thisMenu}.fcFrame

  # Be Verbose
  label ${thisMenu}.verbosePrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Run in Verbose Mode?"

  frame ${thisMenu}.verboseValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.verboseValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.verboseValCheck -variable RGL(Verbose) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.verboseValPrompt ${thisMenu}.verboseValCheck \
       -side left -fill x -in ${thisMenu}.verboseValFrame

  pack ${thisMenu}.verbosePrompt ${thisMenu}.verboseValFrame \
       -side left -in ${thisMenu}.verboseFrame

  # Stats
  label ${thisMenu}.statsPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Output Statistics?"

  frame ${thisMenu}.statsValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.statsValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.statsValCheck -variable RGL(Stats) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.statsValPrompt ${thisMenu}.statsValCheck \
       -side left -fill x -in ${thisMenu}.statsValFrame

  pack ${thisMenu}.statsPrompt ${thisMenu}.statsValFrame \
       -side left -in ${thisMenu}.statsFrame

  # Single-Buffer
  label ${thisMenu}.1bufferPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Single Buffer?"

  frame ${thisMenu}.1bufferValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.1bufferValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.1bufferValCheck -variable RGL(1Buffer) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.1bufferValPrompt ${thisMenu}.1bufferValCheck \
       -side left -fill x -in ${thisMenu}.1bufferValFrame

  pack ${thisMenu}.1bufferPrompt ${thisMenu}.1bufferValFrame \
       -side left -in ${thisMenu}.1bufferFrame

  # Exit Afterwards
  label ${thisMenu}.exitPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Exit Afterwards?"

  frame ${thisMenu}.exitValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.exitValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  checkbutton ${thisMenu}.exitValCheck -variable RGL(NoWait) \
       -fg $DefaultFG -bg $DefaultBG -anchor w -font $PromptFont \
       -highlightthickness 1

  pack ${thisMenu}.exitValPrompt ${thisMenu}.exitValCheck \
       -side left -fill x -in ${thisMenu}.exitValFrame

  pack ${thisMenu}.exitPrompt ${thisMenu}.exitValFrame \
       -side left -in ${thisMenu}.exitFrame

  # Dump Image
  label ${thisMenu}.dumpPrompt -font $DefaultFont -anchor w \
        -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
        -text "Dump Image?"

  frame ${thisMenu}.dumpValFrame -relief flat -bg $DefaultBG
  label ${thisMenu}.dumpValPrompt -relief flat -text $dummy2 \
       -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
  set dumpWidgets [ BuildPullDownMenu $thisMenu ".dumpPD" \
                      { No "Yes, RGBA" "Yes, RGBA-Z" } \
                      ChangeDumpType { 0 1 2 } 0 10 ]

  pack ${thisMenu}.dumpValPrompt ${dumpWidgets} \
       -side left -fill x -in ${thisMenu}.dumpValFrame

  pack ${thisMenu}.dumpPrompt ${thisMenu}.dumpValFrame \
       -side left -in ${thisMenu}.dumpFrame

  pack ${thisMenu}.fpsFrame \
       ${thisMenu}.fcFrame \
       ${thisMenu}.verboseFrame \
       ${thisMenu}.statsFrame \
       ${thisMenu}.1bufferFrame \
       ${thisMenu}.exitFrame \
       ${thisMenu}.dumpFrame \
       -side top -fill x -in ${thisMenu}.mValueFrame

  # Unix supports sound.
  if { $tcl_platform(platform) == "unix" }  {
    # Sound File
    label ${thisMenu}.soundPrompt -font $DefaultFont -anchor w \
          -fg $DefaultFG -bg $DefaultBG -width $promptWidth \
          -text "Sound File:"

    frame ${thisMenu}.soundValFrame -relief flat -bg $DefaultBG
    label ${thisMenu}.soundValPrompt -relief flat -text $dummy2 \
         -fg $DefaultFG -bg $DefaultBG -font $PromptFont -anchor w
    entry ${thisMenu}.soundValEntry -relief sunken \
          -fg $DefaultEntryFG -bg $DefaultEntryBG \
          -width 20 -textvariable RGL(SoundFile) -font $EntryFont

    # Build a "Browse..." button for the sound file entry.
    button ${thisMenu}.soundValBrowse -text "Browse..." -width 7 \
    -command "GetFileName $thisMenu ${thisMenu}.soundValEntry open AIFF"

    pack ${thisMenu}.soundValPrompt ${thisMenu}.soundValEntry \
          ${thisMenu}.soundValBrowse \
         -side left -fill x -in ${thisMenu}.soundValFrame

    pack ${thisMenu}.soundPrompt ${thisMenu}.soundValFrame \
         -side left -in ${thisMenu}.soundFrame

    pack ${thisMenu}.soundFrame \
         -side top -fill x -in ${thisMenu}.mValueFrame
  }

  pack ${thisMenu}.miscTitle \
       -side top -fill x -in ${thisMenu}.miscFrame

  pack ${thisMenu}.mValueFrame \
       -side left -in ${thisMenu}.miscFrame

  pack ${thisMenu}.imageFrame \
       -side top -fill x -in ${thisMenu}.tFrame1

  pack ${thisMenu}.miscFrame \
       -side top -fill x -in ${thisMenu}.tFrame2

  pack ${thisMenu}.tFrame1 \
       ${thisMenu}.tFrame2 \
       -side left -fill y -in ${thisMenu}

  return $thisMenu
};
# -------------------------------------------------------------------------
# Function    : BuildPullDownMenu { parentTag menuTag menuItems callback
#                                   cbItems defaultIdx width }
#
# Description : This procedure constructs the geometry for a pull-down
#               menu, and returns it.
#
# Parameters  : parentTag  : Tag to use as parent.
#               menuTag    : Tag to use for menu.
#               menuItems  : List of menu items.
#               callback   : Name of callback to call.
#               cbItems    : List of things to pass to callback.
#               defaultIdx : Index of default item.
#               width      : Width of menu.
#
# Returns     : Full tag of created geometry.

proc BuildPullDownMenu { parentTag menuTag menuItems callback cbItems \
                         defaultIdx width }  {
  global DefaultFont
  global DefaultFG
  global DefaultBG
  global DefaultMenuFG
  global DefaultMenuBG
  global DefaultMenuAFG
  global DefaultMenuABG
  global DefaultMenuSBG

  set thisMenu [ format "%s%s" ${parentTag} ${menuTag} ]

  menubutton ${thisMenu} -text [ lindex $menuItems $defaultIdx ] \
               -direction below -menu ${thisMenu}.m \
               -relief raised -width $width -anchor w \
               -fg $DefaultMenuFG -bg $DefaultMenuBG \
               -activeforeground $DefaultMenuAFG \
               -activebackground $DefaultMenuABG \
               -indicatoron 1

  menu ${thisMenu}.m -tearoff 0 \
               -fg $DefaultMenuFG -bg $DefaultMenuBG \
               -activeforeground $DefaultMenuAFG \
               -activebackground $DefaultMenuABG \
               -selectcolor $DefaultMenuSBG

  for { set idx 0 } { $idx < [ llength $menuItems ] } { incr idx }  {
    ${thisMenu}.m add command -label [ lindex $menuItems $idx ] \
        -command "$callback [ lindex $cbItems $idx ] ;
                  ${thisMenu} config -text \"[ lindex $menuItems $idx ]\""
  }

  return $thisMenu
};
# -------------------------------------------------------------------------
# Function    : RenderWrapper
#
# Description : This is the main menu for the RenderWrapper program.
#
# Parameters  : void.
#
# Returns     : void.
#
# -------------------------------------------------------------------------
# Function    : StartChild { }
#
# Description : This procedure starts a child process.
#
# Parameters  : void.
#
# Returns     : void.

proc StartChild { }  {
  global CurRenderer
  global CurRIBSource
  global CurRIBFile
  global CurRIBProg
  global CurCWD
  global CmdLine
  global RIBEntry
  global tcl_platform
  global env
  global RW_Path_Env
  global WishExe

  # Make sure a RIB source file or program has been entered.
  if { ( ( $CurRIBSource == "file" ) && \
         ( [ string length [ string trim $CurRIBFile ] ] == 0 ) ) ||
       ( ( $CurRIBSource == "program" ) && \
         ( [ string length [ string trim $CurRIBProg ] ] == 0 ) ) }  {
    tk_messageBox -icon error -type ok -default ok \
	-title "Error!" -parent . \
	-message "Error: You must specify a RIB File or Program to read input from!"
    focus $RIBEntry
    return
  }

  BuildCmdLine

  # set the working directory.
  if { [ string length [ string trim $CurCWD ] ] == 0 }  {
    cd .
  } else {
    cd $CurCWD
  }
  switch -regexp -- $tcl_platform(platform)  { \
    ^macintosh$  {
      ;# Nothing to do here.
    } \
    ^windows$  {
      exec -- $WishExe $env($RW_Path_Env)/render.tcl -- -r$CurRenderer -a$CmdLine -s$CurRIBSource -f$CurRIBFile &
    } \
    ^unix$  {
      exec -- $env($RW_Path_Env)/render.tcl -r$CurRenderer -a$CmdLine -s$CurRIBSource -f$CurRIBFile &
    } \
  }
}

# -------------------------------------------------------------------------
# Function    : StartWishApp { childApp }
#
# Description : This procedure starts a child application.
#
# Parameters  : void.
#
# Returns     : void.

proc StartWishApp { childApp }  {
  global tcl_platform
  global env
  global RW_Path_Env
  global WishExe

  switch -regexp -- $tcl_platform(platform)  { \
    ^macintosh$  {
      ;# Nothing to do here.
    } \
    ^windows$  {
      exec -- $WishExe $childApp &
    } \
    ^unix$  {
      exec -- $childApp &
    } \
  }
}

# -------------------------------------------------------------------------
# Function    : ChangeRenderer { renderer }
#
# Description : This procedure changes sets the renderer to be that
#               selected by the user.
#
# Parameters  : renderer : Name of renderer.
#
# Returns     : void.

proc ChangeRenderer { renderer }  {
  global RendribWidgets
  global RGLWidgets
  global CurRenderer
  global RIBEntry
  global ParamFrame

  if { $CurRenderer != $renderer }  {
    # First, destroy the old widgets.
    switch -regexp -- $CurRenderer  { \
      ^rendrib$  {
        destroy $RendribWidgets
      }
      ^rgl$      {
        destroy $RGLWidgets
      }
    }
    # Then, create the new ones.
    switch -regexp -- $renderer  { \
      ^rendrib$  {
        set rendribDisplay [ BuildRendribLayout $RendribWidgets ]
        pack $rendribDisplay -in $ParamFrame
      }
      ^rgl$      {
        set rglDisplay [ BuildRGLLayout $RGLWidgets ]
        pack $rglDisplay -in $ParamFrame
      }
    }
  }

  # Set focus to the RIBEntry field.
  focus $RIBEntry

  set CurRenderer $renderer
}

# -------------------------------------------------------------------------
# Function    : ChangeSource { source }
#
# Description : This procedure sets the RIB source to be that
#               selected by the user.
#
# Parameters  : source : Name of RIB source.
#
# Returns     : void.

proc ChangeSource { source }  {
  global CurRIBSource
  global CurRIBFile
  global CurRIBProg
  global RIBEntry

  if { $CurRIBSource != $source }  {
    switch -regexp -- $source  { \
      ^file$  {
        $RIBEntry config -textvariable CurRIBFile
      }
      ^program$      {
        $RIBEntry config -textvariable CurRIBProg
      }
    }
  }
  set CurRIBSource $source
}

# -------------------------------------------------------------------------
# Function    : ChangeDumpType { type }
#
# Description : This procedure changes sets the RIB source to be that
#               selected by the user.
#
# Parameters  : type : Type of dump to make.
#
# Returns     : void.

proc ChangeDumpType { type }  {
  global RGL

  set RGL(DumpRGB) $type
}

# -------------------------------------------------------------------------
# Function    : BuildMainWindow { }
#
# Description : This procedure builds the main window.
#
# Parameters  : void.
#
# Returns     : void.

proc BuildMainWindow { }  {
  global CurRenderer
  global CurCWD
  global CurRIBSource
  global CurRIBFile
  global RendribWidgets
  global RGLWidgets
  global UpperFrame
  global ParamFrame
  global LowerFrame
  global RIBEntry
  global DefaultFG
  global DefaultBG
  global DefaultMenuFG
  global DefaultMenuBG
  global DefaultMenuAFG
  global DefaultMenuABG
  global DefaultMenuSBG
  global DefaultEntryFG
  global DefaultEntryBG
  global DefaultFont
  global EntryFont
  global tcl_platform
  set CurCWD [ pwd ]

  set parentTag ".m"
  frame $parentTag -bg $DefaultBG -bd 1 -relief raised
  pack $parentTag

  # Build menu accross the top.
  set m $parentTag.mbar
  menu $m -tearoff 0 -fg $DefaultMenuFG -bg $DefaultMenuBG \
                     -activeforeground $DefaultMenuAFG \
                     -activebackground $DefaultMenuABG \
                     -selectcolor $DefaultMenuSBG

  # Definition of "File" menu.
  set m $parentTag.mbar.file
  menu $m -tearoff 0 -fg $DefaultMenuFG -bg $DefaultMenuBG \
                     -activeforeground $DefaultMenuAFG \
                     -activebackground $DefaultMenuABG \
                     -selectcolor $DefaultMenuSBG

  $parentTag.mbar add cascade -label "File" -menu $m -underline 0 \
                              -font $DefaultFont

  $m add command -label "Exit" -font $DefaultFont -underline 0 \
                               -command { CleanUpAndExit 0 }

  # Definition of "Tools" menu.
  set m $parentTag.mbar.tools
  menu $m -tearoff 0 -fg $DefaultMenuFG -bg $DefaultMenuBG \
                     -activeforeground $DefaultMenuAFG \
                     -activebackground $DefaultMenuABG \
                     -selectcolor $DefaultMenuSBG

  $parentTag.mbar add cascade -label "Tools" -menu $m -underline 0 \
                              -font $DefaultFont

  $m add command -label "TkMatMan" -font $DefaultFont -underline 0 \
                               -command { StartWishApp tkmatman }

  # define "Help" menu.
  set m $parentTag.mbar.help
  menu $m -tearoff 0 -fg $DefaultMenuFG -bg $DefaultMenuBG \
                     -activeforeground $DefaultMenuAFG \
                     -activebackground $DefaultMenuABG \
                     -selectcolor $DefaultMenuSBG

  $parentTag.mbar add cascade -label "Help" -menu $m -underline 0 \
                              -font $DefaultFont

  $m add command -label "Program Help" -command "GiveHelp $m ; grab . " \
                 -font $DefaultFont -underline 0

  $m add sep

  $m add command -label "About..." -command "GiveAbout $m ; grab ." \
                 -font $DefaultFont -underline 0

  # Add the menu to the window.
  . configure -menu $parentTag.mbar

  set UpperFrame [ format "%s%s" $parentTag ".upperFrame" ]
  set ParamFrame [ format "%s%s" $parentTag ".paramFrame" ]
  set LowerFrame [ format "%s%s" $parentTag ".lowerFrame" ]

  frame $UpperFrame -bg $DefaultBG -relief raised -bd 1
  frame $ParamFrame -bg $DefaultBG -relief raised -bd 1
  frame $LowerFrame -bg $DefaultBG -relief raised -bd 1

  # Build a frame for the prompts.
  set thisFrame ${UpperFrame}.promptFrame1
  frame $thisFrame -bg $DefaultBG -relief flat
  label ${thisFrame}.rendererPrompt -font $DefaultFont -anchor w \
      -fg $DefaultFG -bg $DefaultBG \
      -text "Renderer to use:"
  label ${thisFrame}.sourcePrompt -font $DefaultFont -anchor w \
      -fg $DefaultFG -bg $DefaultBG \
      -text "RIB Source:"
  pack ${thisFrame}.rendererPrompt \
       ${thisFrame}.sourcePrompt \
       -side top -fill x -in $thisFrame

  # Build a frame for the prompts.
  set thisFrame ${UpperFrame}.promptFrame2
  frame $thisFrame -bg $DefaultBG -relief flat
  label ${thisFrame}.cwdPrompt -font $DefaultFont -anchor w \
      -fg $DefaultFG -bg $DefaultBG \
      -text " Working Directory: "
  label ${thisFrame}.filePrompt -font $DefaultFont -anchor w \
      -fg $DefaultFG -bg $DefaultBG \
      -text " File(s) or Program:"
  pack ${thisFrame}.cwdPrompt \
       ${thisFrame}.filePrompt \
       -side top -fill x -in $thisFrame

  # Build a frame for the values.
  set thisFrame ${UpperFrame}.valFrame1
  frame $thisFrame -bg $DefaultBG -relief flat

  # Build the pull-down for renderer.
  set renderer [ BuildPullDownMenu $parentTag ".renderer" \
               { rendrib rgl } \
               ChangeRenderer { rendrib rgl } 0 20 ]
  # Build the pull-down for input type.
  set ribSource [ BuildPullDownMenu $parentTag ".ribsource" \
                { "Read from a RIB File" "Output from a Program" } \
                ChangeSource { file program } 0 20 ]

  # Build a frame for the values.
  set thisFrame ${UpperFrame}.valFrame2
  frame $thisFrame -bg $DefaultBG -relief flat

  #Build an entry widget for the current working directory.
  set cwdEntryFrame [ format "%s%s" $parentTag ".cwdEntryFrame" ]
  frame $cwdEntryFrame -bg $DefaultBG -relief flat
  set CWDEntry [ format "%s%s" $parentTag ".cwdEntry" ]
  entry $CWDEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 25 -textvariable CurCWD -font $EntryFont

  # Build a "Browse..." button for the CWD.
  set cwdBrowse [ format "%s%s" $parentTag ".cwdBrowse" ]
  button $cwdBrowse -text "Browse..." -width 7 -state disabled \
         -command "GetFileName $parentTag $CWDEntry dir RIB"

#  pack $CWDEntry $cwdBrowse -side left -padx 2 -in $cwdEntryFrame
  pack $CWDEntry -side left -padx 2 -in $cwdEntryFrame

  #Build an entry widget for a source file/program.
  set ribEntryFrame [ format "%s%s" $parentTag ".ribEntryFrame" ]
  frame $ribEntryFrame -bg $DefaultBG -relief flat
  set RIBEntry [ format "%s%s" $parentTag ".ribEntry" ]
  entry $RIBEntry -relief sunken \
        -fg $DefaultEntryFG -bg $DefaultEntryBG \
        -width 25 -textvariable CurRIBFile -font $EntryFont

  # Build a "Browse..." button for the RIB file entry.
  set ribBrowse [ format "%s%s" $parentTag ".ribBrowse" ]
  button $ribBrowse -text "Browse..." -width 7 \
         -command "GetFileName $parentTag $RIBEntry open RIB"

  pack $RIBEntry $ribBrowse -side left -padx 2 -in $ribEntryFrame

  # Place them in the upper frame.
  pack $renderer $ribSource -side top -anchor w \
       -in ${UpperFrame}.valFrame1

  # Place them in the upper frame.
  pack $cwdEntryFrame $ribEntryFrame -side top -anchor w \
       -in ${UpperFrame}.valFrame2

  pack ${UpperFrame}.promptFrame1 ${UpperFrame}.valFrame1 \
       ${UpperFrame}.promptFrame2 ${UpperFrame}.valFrame2 \
       -side left -in $UpperFrame

  # Set focus to the RIBEntry field.
  focus $RIBEntry

  # Build a frame for the Buttons.
  set thisFrame ${LowerFrame}.buttonFrame
  frame $thisFrame -bg $DefaultBG -relief flat
  button ${thisFrame}.renderButton -relief raised -bd 4 -text "Render" \
         -font $DefaultFont -command { StartChild } -width 10

  button ${thisFrame}.doneButton -text "Exit" -anchor c \
         -relief raised -bd 4 -font $DefaultFont \
         -command { CleanUpAndExit 0 } -width 10

  pack ${thisFrame}.renderButton ${thisFrame}.doneButton \
         -side left -padx 40 -pady 4 -in $thisFrame
  pack $thisFrame -in $LowerFrame

  # Create parameter names for rendrib and rgl.
  set RendribWidgets [ format "%s%s" ${parentTag} ".rendrib" ]
  set RGLWidgets [ format "%s%s" ${parentTag} ".rgl" ]

  # Remember which params we are showing now.
  set rendribDisplay [ BuildRendribLayout $RendribWidgets ]
  pack $rendribDisplay -side top -in $ParamFrame
  set CurRenderer  "rendrib"
  set CurRIBSource "file"

  pack $UpperFrame -side top -in $parentTag
  pack $ParamFrame -side top -in $parentTag
  pack $LowerFrame -side top -fill x -in $parentTag
}

# -------------------------------------------------------------------------
# This is the main procedure.
#

set RW_Path_Env RENDERWRAPPER_PATH

# Check for the necessary environment variables.
if { ![ info exists env($RW_Path_Env) ] }  {
  puts ""
  puts "Error:"
  puts " The environment variable \"$RW_Path_Env\" is not set."
  puts " Please set this variable equal to the full-path of the"
  puts " directory where the file \"rw.tcl\" resides."
  puts ""
  tk_messageBox -icon error -type ok -default ok \
        -title "Error!" -parent . \
        -message "Error: The environment variable \"$RW_Path_Env\" is not set! \
Please set this variable equal to the full-path of the directory where the file \"rw.tcl\" resides, and restart."
  exit
}

# This line allows Tcl to find the common procedures.
set auto_path [ linsert $auto_path 0 [ pwd ] ]
set auto_path [ linsert $auto_path 0 [ file join [ pwd ] lib ] ]
set auto_path [ linsert $auto_path 0 $env($RW_Path_Env) ]
set auto_path [ linsert $auto_path 0 [ file join $env($RW_Path_Env) lib ] ]

# Initialize global variables.
InitProg $argc $argv

# Change the title.
wm title . $ProgName
wm geometry . "+25+50"

# Make the "Return" key move to the next entry.
bind Entry <Return>  {
  set newEntry [ tk_focusNext %W ]
  focus $newEntry
  break
}

# Set the platform-dependent stuff.
switch -regexp -- $tcl_platform(platform)  { \
  ^macintosh$  {
     ;# Nothing to do here.
  } \
  ^windows$  {
     ;# Nothing to do here.
  } \
  ^unix$  {
    bind all <ISO_Left_Tab>  {
      set newEntry [ tk_focusPrev %W ]
      focus $newEntry
      break
    }
  } \
}

BuildMainWindow

focus -force .


# -------------------------------------------------------------------------
